<?php

namespace App\Http\Controllers;

use App\Exporters\InitialInventoryExporter;
use App\Http\Controllers\Traits\ImportsData;
use App\Models\FifoLayer;
use App\Models\InventoryMovement;
use App\Models\StockTakeItem;
use App\Models\Warehouse;
use App\Repositories\StockTakeRepository;
use Illuminate\Database\Eloquent\Builder;
use Symfony\Component\HttpFoundation\BinaryFileResponse;

class InitialInventoryController extends Controller
{
    use ImportsData;

    public StockTakeRepository $stockTakes;

    public function __construct()
    {
        parent::__construct();
        $this->stockTakes = app(StockTakeRepository::class);
    }

    protected function getModel(): string
    {
        // Using FifoLayer model which points to InitialInventoryDataImporter
        return FifoLayer::class;
    }

    public function export(Warehouse $warehouse): BinaryFileResponse
    {
        $export = new InitialInventoryExporter($this->stockTakes->getInitialInventoryForWarehouse($warehouse), $warehouse, 'csv');

        return response()->download($export->export())->deleteFileAfterSend(true);
    }
}
