<?php

namespace App\Http\Controllers;

use App\Notifications\MonitoringMessage;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Notification;

class HorizonController extends Controller
{
    const SLACK_ALERTS_CHANNEL = 'slack.alerts';

    /**
     * Restart Horizon
     */
    public function restartHorizon(Request $request)
    {
        // Horizon restart cannot be executed by web user, so we can only
        // request it and wait for root or the deploy user to honor that
        // request.

        // Teoretically Horizon could be restarted by Horizon itself, but if
        // it's non responsive it's better to have a separate monitor do this
        // job.

        \App\Helpers\HorizonHelper::requestRestart();

        $message = 'Restart requested by user. ';

        $message = "SKU HORIZON:\n$message\n".env('APP_URL', 'SKU.io');
        Notification::route('slack', config(self::SLACK_ALERTS_CHANNEL))
            ->notify(new MonitoringMessage($message));

        return 'Horizon restart requested.'.
            '<script>setTimeout(()=>top.location.href="/horizon",3000);</script>';
    }
}
