<?php

namespace App\Http\Controllers;

use App\Data\CustomFieldValueData;
use App\Models\CustomField;
use App\Models\CustomFieldValue;
use App\Repositories\CustomFieldValueRepository;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;

class CustomFieldValueController extends Controller
{
    public function index()
    {
        return CustomFieldValue::all();
    }

    public function store(Request $request)
    {
        $inputs = $request->validate([
            'custom_field_id' => ['required', 'integer', 'exists:custom_fields,id'],
            'link_id' => ['required', 'integer'],
            'value' => ['required'],
        ]);

        $customField = CustomField::findOrFail($inputs['custom_field_id']);

        return app(CustomFieldValueRepository::class)->save(CustomFieldValueData::from([
            'custom_field_id' => $inputs['custom_field_id'],
            'link_id' => $inputs['link_id'],
            'link_type' => $customField->link_type,
            'value' => $inputs['value'],
        ]));
    }

    public function update(Request $request, CustomFieldValue $customFieldValue)
    {
        $inputs = $request->validate([
            'value' => ['required'],
        ]);

        return app(CustomFieldValueRepository::class)->save(CustomFieldValueData::from([
            'id' => $customFieldValue->id,
            'custom_field_id' => $customFieldValue->custom_field_id,
            'link_id' => $customFieldValue->link_id,
            'link_type' => $customFieldValue->link_type,
            'value' => $inputs['value'],
        ]));
    }

    public function destroy(CustomFieldValue $customFieldValue): JsonResponse
    {
        $customFieldValue->delete();

        return response()->json();
    }
}
