<?php

namespace App\Http\Controllers;

use App\DataTable\DataTable;
use App\DTO\CustomFieldDto;
use App\Http\Resources\CustomFieldResource;
use App\Models\CustomField;
use App\Repositories\CustomFieldRepository;
use Illuminate\Http\Request;

class CustomFieldController extends Controller
{
    use DataTable;

    public function store(Request $request)
    {
        $validated = $request->validate([
            'name' => ['required'],
            'link_type' => ['required'],
            'archived_at' => ['nullable', 'date'],
        ]);

        $customField = app(CustomFieldRepository::class)->save(CustomFieldDto::from([
            'name' => $validated['name'],
            'link_type' => $validated['link_type'],
        ]));

        return new CustomFieldResource($customField);
    }

    public function update(Request $request, CustomField $customField)
    {
        $inputs = $request->validate([
            'name' => ['sometimes'],
            'link_type' => ['sometimes'],
            'archived_at' => ['sometimes', 'nullable', 'date'],
        ]);

        return app(CustomFieldRepository::class)->save(CustomFieldDto::from(array_merge(
            $inputs,
            ['id' => $customField->id],
        )
        ));
    }

    public function destroy(CustomField $customField)
    {
        $customField->delete();

        return $this->response->setMessage(__('messages.success.delete', [
            'resource' => 'customField',
            'id' => $customField->name,
        ]));
    }

    protected function getModel()
    {
        return CustomField::class;
    }

    protected function getResource()
    {
        return CustomFieldResource::class;
    }
}
