<?php

namespace App\Http\Controllers;

use App\Models\Currency;
use App\Response;
use Illuminate\Http\JsonResponse;

class ConstantController extends Controller
{
    /**
     * display all countries.
     *
     * @return Response|JsonResponse
     */
    public function countries()
    {
        $countries = null;

        $countries = \App\Models\Constant\ConstantsCountry::with([]);

        if (request()->has('code') && ! is_null(request('code'))) {
            $countries->where('code', 'like', '%'.request('code').'%');
        }

        if (request()->has('name') && ! is_null(request('name'))) {
            $countries->where('name', 'like', '%'.request('name').'%');
        }

        $limit = intval(request('limit', 10));

        if ($limit == -1) {
            return $this->response->addData($countries->get());
        }

        return $this->response->setData($countries->paginate($limit)->toArray());
    }

    public function countriesGrouped()
    {
        $countries = \App\Models\Constant\ConstantsContinent::with([])->get(['name', 'code']);

        return $this->response->addData($countries);
    }

    /**
     * display all currencies.
     *
     * @return Response|JsonResponse
     */
    public function currencies()
    {
        $currencies = \App\Models\Constant\ConstantsCurrency::query();

        if (request()->has('code') && ! is_null(request('code'))) {
            $currencies->where('code', 'like', '%'.request('code').'%');
        }

        if (request()->has('name') && ! is_null(request('name'))) {
            $currencies->where('name', 'like', '%'.request('name').'%');
        }

        $limit = intval(request('limit', 10));

        // add default currency to response
        $response = ['default_currency_code' => Currency::default()->code];

        if ($limit == -1) {
            $response['data'] = $currencies->get()->toArray();
        } else {
            $response = array_merge($response, $currencies->paginate($limit)->toArray());
        }

        return $this->response->setData($response);
    }

    /**
     * get states by country code and search by name.
     *
     *
     * @return Response|JsonResponse
     */
    public function states($countryCode)
    {
        $states = \App\Models\Constant\ConstantsCountry::whereCode($countryCode)->first()->states();

        if (request()->has('name') && ! is_null(request('name'))) {
            $states->where('name', 'like', '%'.request('name').'%');
        }

        $limit = intval(request('limit', 10));

        if ($limit == -1) {
            return $this->response->addData($states->get());
        }

        return $this->response->setData($states->paginate($limit)->toArray());
    }

    /**
     * get Zips by country code and search by zip.
     */
    public function zips($countryCode): Response
    {
        $zips = \App\Models\Constant\ConstantsCountry::whereCode($countryCode)->first()->zips();

        if (request()->has('zip') && ! is_null(request('zip'))) {
            $zips->where('zip', 'like', '%'.request('zip').'%');
        }

        $limit = intval(request('limit', 10));

        if ($limit == -1) {
            return $this->response->addData($zips->get());
        }

        return $this->response->setData($zips->paginate($limit)->toArray());
    }

    /**
     * Get Address details by country and zip.
     */
    public function getAddress(string $country_code, string $zip_code): Response
    {
        return $this->response->addData(\App\Models\Constant\ConstantsZipcode::whereCountryCode($country_code)->whereZip($zip_code)->first());
    }
}
