<?php

namespace App\Http\Controllers;

use App\Data\BlemishedProductData;
use App\Http\Resources\ProductResource;
use App\Managers\BlemishedProductManager;
use App\Models\Product;
use App\Response;
use Exception;
use Throwable;

class BlemishedProductController extends Controller
{
    protected BlemishedProductManager $blemishedProductManager;

    public function __construct(BlemishedProductManager $blemishedProductManager)
    {
        parent::__construct();
        $this->blemishedProductManager = $blemishedProductManager;
    }

    /**
     * @throws Throwable
     */
    public function store(BlemishedProductData $data): Response
    {
        $blemishedProduct = $this->blemishedProductManager->createBlemishedProduct($data);

        return $this->response
            ->setMessage(__('messages.success.create', ['resource' => 'product']))
            ->addData(ProductResource::make($blemishedProduct));
    }

    /**
     * @throws Exception
     */
    public function generateSkuPattern(Product $product): Response
    {
        $generatedPattern = $product->generateSkuPattern();
        return $this->response->addData(['sku' => $generatedPattern]);
    }
}
