<?php

namespace App\Http\Controllers;

use App\Http\Resources\PurchaseOrderResource;
use App\Models\PurchaseOrder;
use App\Services\PurchaseOrder\PurchaseOrderManager;
use Illuminate\Http\Request;

class ApplyPurchaseOrderDiscountLinesController extends PurchaseOrderController
{
    public function __invoke(Request $request, PurchaseOrder $purchaseOrder)
    {
        $inputs = $this->validate($request, [
            'discount_rate' => 'required|numeric|between:0,1',
        ]);

        app(PurchaseOrderManager::class)->applyDiscountLines($purchaseOrder, $inputs['discount_rate']);

        return $this->response
            ->setMessage('Discount rate successfully applied.')
            ->addData(PurchaseOrderResource::make($purchaseOrder));
    }
}
