<?php

namespace App\Helpers;

use DOMDocument;
use Exception;
use Illuminate\Support\Arr;
use RuntimeException;
use SimpleXMLElement;

trait ValidatesXml
{

    protected function validateXmlPayload(string $payload): bool
    {
        libxml_use_internal_errors(true);
        $document = new DOMDocument();

        return $document->loadXML($payload);
    }

    /**
     * Parses a list of XPaths and returns a Dictionary structure with a key for the
     * desired XPath
     *
     * @param string $response
     * @param array<string> $xPaths
     * @param array<string> $knownErrorXPaths
     * @param bool $stringify
     *
     * @return array<string, mixed>
     * @throws Exception
     */
    protected function parseResponseXPaths(
        string $response,
        array|string $xPaths,
        array $knownErrorXPaths = [],
        bool $stringify = true,
    ): array
    {
        try {
            $xml = new SimpleXMLElement($response);

            $knownErrorXPaths = array_merge([
                '//Result',
                '//ErrorType'
            ], $knownErrorXPaths);

            $allXPaths = array_merge($knownErrorXPaths, Arr::wrap($xPaths));
            $parsed = [];
            foreach ($allXPaths as $xPath) {
                $dataNode = $xml->xpath($xPath);
                if (!empty($dataNode)) {
                    $parsed[$xPath] = $stringify ? (string)$dataNode[0] : $dataNode;
                } else {
                    $parsed[$xPath] = null;
                }
            }

            return $parsed;
        } catch (Exception $e) {
            throw new RuntimeException(
                message: 'API response was not valid XML.',
                previous: $e
            );
        }
    }

}