<?php

namespace App\Helpers;

use Illuminate\Support\Str;

class FactoryHelper
{
    /**
     * The default Laravel "Factory Name Guesser" does not support modules.
     */
    public static function guessFactoryName(string $modelName): string
    {
        $appNamespace = 'App\\';

        if (str_starts_with($modelName, $appNamespace)) {
            // regular model from the main application
            // Adapted from original code from anonymous function in \Illuminate\Database\Eloquent\Factories\Factory::resolveFactoryName
            $modelName = Str::startsWith($modelName, $appNamespace.'Models\\')
                ? Str::after($modelName, $appNamespace.'Models\\')
                : Str::after($modelName, $appNamespace);

            return 'Database\\Factories\\'.$modelName.'Factory';
        } elseif (str_starts_with($modelName, 'Modules\\')) {
            // Module model
            $success = preg_match('~Modules\\\\([^\\\\]*)\\\\Entities\\\\(.*)~', $modelName, $matches);
            if (! $success) {
                throw new \Exception('provided model name seems to be part of a module but cannot determine the factory');
            }
            $moduleName = $matches[1];
            $modelNameEnd = $matches[2];

            return 'Modules\\'.$moduleName.'\\Database\\Factories\\'.$modelNameEnd.'Factory';
        } else {
            // unknown model
            throw new \Exception('Cannot determine factory for provided model name');
        }
    }
}
