<?php

namespace App\Helpers;

use App\Lib\XlsxWriter\XlsxWriter;

class ExcelHelper
{
    /**
     * @deprecated If there is a requirement to read a CSV, Excel or other spreadsheet like
     *             file, instead use \App\Lib\DataList\DataListFactory
     *             If for some reason there is a need to work directly with the xlsx2csv binary
     *             use \App\Lib\Xlsx2Csv\Xlsx2Csv
     */
    public static function xlsx2csv($input_file_path, $output_file_name, $options = [])
    {
        $output_file_path = $options['output_file_path'] ?? '';
        $executable_path = $options['executable_path'] ?? dirname(dirname(__FILE__)).'/Lib/Xlsx2Csv/';
        $executable_file = $options['executable_file'] ?? 'xlsx2csv';
        $arg_row_limit = ' -l '.($options['row_limit'] ?? '500000');
        $arg_omit_empty_rows = ' -c';
        $arg_delimiter = ' -d ,';
        $arg_output_file = ' -o "'.$output_file_path.$output_file_name.'"';
        $arg_input_file = ' "'.$input_file_path.'"';

        $command =
      $executable_path.
      $executable_file.
      $arg_row_limit.
      $arg_omit_empty_rows.
      $arg_delimiter.
      $arg_output_file.
      $arg_input_file;

        $response = shell_exec($command);

        // check if output file exists and is more than 0 in size
        if (1) {
            return $output_file_path.$output_file_name;
        } else {
            return null;
        }
    }

    public static function array2csvfile($filename, &$headers, &$records, $options = [])
    {
        if (empty($headers)) {
            return null;
        }

        $storage_path = $options['storage_path'] ?? storage_path('exports');
        $csvfilename = $storage_path.'/'.$filename;

        if (file_exists($csvfilename)) {
            unlink($csvfilename);
        }

        $csvfile = fopen($csvfilename, 'w');

        fputcsv($csvfile, $headers);

        foreach ($records as $fields) {
            fputcsv($csvfile, $fields);
        }

        fclose($csvfile);

        $chmod = $options['chmod'] ?? 0666;
        chmod($csvfilename, $chmod);

        return $csvfilename;
    }

    public static function array2xlsxfile($filename, &$headers, &$records, $options = null)
    {
        if (empty($headers)) {
            return null;
        }

        if (empty($options['storage_path'])) {
            $storage_path = storage_path('exports');
        } else {
            $storage_path = $options['storage_path'];
            unset($options['storage_path']);
        }

        $xlsxfilename = $storage_path.'/'.$filename;

        if (file_exists($xlsxfilename)) {
            unlink($xlsxfilename);
        }

        $writer = new XlsxWriter();

        if (empty($options)) {
            $writer->writeSheetHeader('Listings', $headers);
        } else {
            $writer->writeSheetHeader('Listings', $headers, $options);
        }
        foreach ($records as $record) {
            $writer->writeSheetRow('Listings', $record);
        }
        $writer->writeToFile($xlsxfilename);

        return $xlsxfilename;
    }
}
