<?php

namespace App\Ghostscript;

class Ghostscript
{
    protected $outputFile;

    protected $sourceFiles = [];

    public function __construct(?string $outputFile = null, array $sourceFiles = [])
    {
        $this->outputFile = $outputFile;
        $this->sourceFiles = $sourceFiles;
    }

    public function setOutputFile(string $outputFile)
    {
        $this->outputFile = $outputFile;
    }

    public function setSourceFiles(array $sourceFiles)
    {
        $this->sourceFiles = $sourceFiles;
    }

    public function addSourceFile(string $sourceFile)
    {
        $this->sourceFiles[] = $sourceFile;
    }

    private function getGhostscriptPath(): string
    {
        if (strlen(decbin(~0)) == 64) {
            return base_path('app/Ghostscript/bin/gs-9550-linux-x86_64');
        }

        return base_path('app/Ghostscript/bin/gs-9550-linux-x86');
    }

    /**
     * Merge source files in the output file.
     *
     * @return false|string|null NULL: success, string: failed (ghostscript error)
     */
    public function combine(int $permissions = 0666)
    {
        if (empty($this->outputFile) || empty($this->sourceFiles)) {
            throw new \InvalidArgumentException('outputFile and sourceFiles are required');
        }

        $sourceFiles = implode(' ', $this->sourceFiles);

        $command = "{$this->getGhostscriptPath()} -q -dNOPAUSE -sDEVICE=pdfwrite -sOUTPUTFILE={$this->outputFile} -dBATCH {$sourceFiles} 2>&1";

        $status = shell_exec($command);

        // success
        if (is_null($status)) {
            @chmod($this->outputFile, $permissions);
        }

        return $status;
    }
}
