<?php

namespace App\FilesystemAdapters;

use League\Flysystem\Local\LocalFilesystemAdapter;

class Local extends LocalFilesystemAdapter
{
    /**
     * Default permissions
     * allow read and write to public visibility of the file
     *
     * @var array
     */
    public static $permissions = [
        'file' => [
            'public' => 0666,
            'private' => 0600,
        ],
        'dir' => [
            'public' => 0755,
            'private' => 0700,
        ],
    ];

    /**
     * {@inheritDoc}
     */
    public function setVisibility($path, $visibility): void
    {
        // the content added to the file, but it can't chmod the file (different owner), so don't throw an exception
        try {
            parent::setVisibility($path, $visibility);
        } catch (\Throwable $exception) {
        }
    }
}
