<?php

namespace App\Exports;

use Illuminate\Database\Eloquent\Collection;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\WithHeadings;

class AmazonReportSettlementTypeMappingsExport implements FromArray, WithHeadings
{
    public function __construct(private Collection $items)
    {
    }

    public function array(): array
    {
        return $this->items->map(function ($item) {
            return [
                'Financial Code' => $item->financial_code,
                'Nominal Code' => $item->nominalCode ? $item->nominalCode->code.' - '.$item->nominalCode->name : '',
            ];
        })->toArray();
    }

    public function headings(): array
    {
        return [
            'Financial Code',
            'Nominal Code',
        ];
    }
}