<?php

namespace App\Exporters;

use App\Exporters\Formatters\ExportFormatterFactory;
use App\Models\PurchaseOrder;
use App\Services\PurchaseOrder\PurchaseOrderBuilder\PurchaseOrderBuilderLine;
use Illuminate\Support\Collection;

class PurchaseOrderBuilderExporter extends BaseExporter
{
    const FILE_SUFFIX = '_po_builder';

    public function __construct(Collection $data, string $format)
    {
        parent::__construct(
            $this->makeRecords($data),
            $format,
            $this->makeFilename($format),
            $this->makeHeaders($format)
        );
    }

    private function makeRecords(Collection $data): array
    {
        return $data->map(function (PurchaseOrderBuilderLine $line) {
            $supplierProduct = $line->getSupplierProduct();

            return [
                'sku' => $supplierProduct->product->sku,
                'barcode' => $supplierProduct->product->barcode,
                'description' => $supplierProduct->product->name,
                'quantity' => $line->getQuantity(),
                'unit_cost' => $supplierProduct->default_supplier_pricing?->price ?? 0.00,
                'discount_rate' => 0,
                'tax_rate_id' => '',
            ];
        })
            ->toArray();
    }

    private function makeFilename(string $format): string
    {
        return intval(date('YmdHis').rand(0, 99999)).'_'.auth()->id().self::FILE_SUFFIX.'.'.$format;
    }

    private function makeHeaders(string $format): array
    {
        $headers = [
            'sku' => 'string',
            'barcode' => 'string',
            'description' => 'string',
            'quantity' => 'integer',
            'unit_cost' => 'decimal',
            'discount_rate' => 'decimal',
            'tax_rate_id' => 'integer',
        ];

        return $format === ExportFormatterFactory::EXPORT_FORMAT_CSV ? array_keys($headers) : $headers;
    }
}
