<?php

namespace App\Exporters\Jasper;

use App\Helpers;
use App\Models\PurchaseOrder;
use App\Models\PurchaseOrderLine;

class PurchaseOrderPicklistTransformer
{
    public static function transform(PurchaseOrder $purchaseOrder): array
    {
        $orderItems = [];

        $orderData = static::purchaseOrder($purchaseOrder);

        foreach ($purchaseOrder->purchaseOrderLines->whereNotNull('product_id') as $purchaseOrderLine) {
            $purchaseOrderLine->setRelation('purchaseOrder', $purchaseOrder);

            if ($line = static::purchaseOrderLine($purchaseOrderLine)) {
                $orderItems[] = array_merge($line, $orderData);
            }
        }

        return $orderItems;
    }

    private static function purchaseOrder(PurchaseOrder $purchaseOrder): array
    {
        return [
            'grouping_id' => $purchaseOrder->id,
            'order_number' => $purchaseOrder->purchase_order_number,
            'order_date' => $purchaseOrder->purchase_order_date->toFormattedDateString(),
            'logo' => Helpers::getBase64OfImage($purchaseOrder->store->logo_url, 250),
            'store_name' => $purchaseOrder->store->company_name ?: $purchaseOrder->store->name,
            'store_address' => $purchaseOrder->store?->address?->formatForInvoice(false) ?: '',
            'warehouse_name' => $purchaseOrder->destinationWarehouse->name,
            'warehouse_address' => $purchaseOrder?->destinationWarehouse?->address?->formatForInvoice(false) ?: '',
            'supplier_name' => $purchaseOrder->supplier->name,
            'supplier_address' => $purchaseOrder->supplier->address?->formatForInvoice(false) ?: '',
            'shipping_method' => $purchaseOrder?->requestedShippingMethod?->full_name ?: $purchaseOrder->requested_shipping_method ?: '',
        ];
    }

    private static function purchaseOrderLine(PurchaseOrderLine $purchaseOrderLine): array
    {
        if ($purchaseOrderLine->unreceived_quantity == 0) {
            return [];
        }

        return [
            'sku' => $purchaseOrderLine->product->sku,
            'product_image' => Helpers::getBase64OfImage($purchaseOrderLine->product->image ?? null, 250),
            'description' => $purchaseOrderLine->description,
            'qty' => $purchaseOrderLine->unreceived_quantity,
            'supplier_sku' => $purchaseOrderLine->supplierProduct->supplier_sku ?: '',
        ];
    }
}
