<?php
/**
 * Created by PhpStorm.
 * User: brightantwiboasiako
 * Date: 7/10/20
 * Time: 8:11 AM.
 */

namespace App\Exceptions\WarehouseTransfers;

use App\Models\WarehouseTransfer;

class NotOpenWarehouseTransferException extends \Exception
{
    /**
     * @var WarehouseTransfer
     */
    public $transfer;

    /**
     * WarehouseTransferOpenException constructor.
     */
    public function __construct(WarehouseTransfer $transfer, ?string $message = null)
    {
        $this->transfer = $transfer;
        $this->message = $message;
    }

    public function __toString()
    {
        return $this->message ? $this->getMessage() : 'Warehouse transfer '.$this->transfer->id.' is not open.';
    }
}
