<?php

namespace App\Exceptions;

use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Models\SalesOrderLine;
use Exception;
use Throwable;

class SalesOrderFulfillmentReservationException extends Exception
{
    public function __construct(
        public SalesOrder $salesOrder,
        public ?SalesOrderLine $salesOrderLine = null,
        public ?SalesOrderFulfillment $fulfillment = null,
        string $message = '',
        int $code = 0,
        ?Throwable $previous = null
    ) {
        parent::__construct($message, $code, $previous);
    }
}
