<?php

namespace App\Exceptions\SalesOrder;

use App\Models\SalesOrder;
use App\Models\SalesOrderFulfillment;
use App\Models\SalesOrderLine;
use Exception;
use Throwable;

class SalesOrderFulfillmentException extends Exception
{
    public function __construct(
        public SalesOrder $salesOrder,
        public ?SalesOrderFulfillment $fulfillment = null,
        string $message = '',
        public array $errors = [],
        int $code = 0,
        ?Throwable $previous = null
    ) {
        parent::__construct($message, $code, $previous);
    }
}
