<?php

namespace App\Exceptions;

use App\Models\StockTakeItem;
use App\Response;

class NegativeInventoryStockTakeException extends \Exception
{
    public function __construct(protected array $lines)
    {
        $message = __('messages.stock_take.negative_snapshot_inventory');
        parent::__construct($message);
    }

    public function getResponseError(): array
    {
        $lines = array_map(fn (StockTakeItem $item) => [
            'id' => $item->id,
            'product_id' => $item->product_id,
            'product_sku' => $item->product->sku,
        ], $this->lines);

        return Response::getError($this->getMessage(), Response::CODE_NEGATIVE_SNAPSHOT_INVENTORY, 'items', $lines);
    }
}
