<?php

namespace App\Exceptions\IntegrationInstance\Magento;

use App\Response;

class UnableToCreateBundleProductException extends \Exception
{
    public function __construct(string $componentSku, string $reason)
    {
        $message = "Unable to create bundle component '$componentSku': $reason";

        parent::__construct($message);
    }

    public function getResponseErrorCode(): string
    {
        return 'Listing'.Response::CODE_UNACCEPTABLE;
    }
}
