<?php

namespace App\Exceptions\IntegrationInstance\Magento;

use App\Response;

class BundleComponentUnavailableException extends \Exception
{
    public function __construct(string $componentSku)
    {
        $message = "The bundle component '$componentSku' has not been downloaded yet or has been deleted from Magento";

        parent::__construct($message);
    }

    public function getResponseErrorCode(): string
    {
        return 'Listing'.Response::CODE_UNAVAILABLE;
    }
}
