<?php

namespace App\Exceptions;

use App\Response;
use Exception;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Arr;
use Illuminate\Support\Str;
use Throwable;

class DuplicateEntryException extends Exception
{
    public function __construct(protected Model $model, protected string|array $uniqueKey, protected ?Throwable $previous = null)
    {
        $message = $this->formatMessage();

        parent::__construct($message, 0, $previous);
    }

    private function formatMessage(): string
    {
        $uniqueKey = [];
        foreach (Arr::wrap($this->uniqueKey) as $key) {
            $uniqueKey[] = "'{$this->model->{$key}}'";
        }
        $uniqueKey = implode(',', $uniqueKey);
        $model = Str::headline($this->model->getTable());

        return "Duplicate entry {$uniqueKey} for {$model}";
    }

    public function getResponseCode(): string
    {
        return Response::CODE_DUPLICATE_ENTRY;
    }
}
