<?php

namespace App\Events;

use App\Models\WarehouseTransferShipmentReceipt;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class WarehouseTransferReceived implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public WarehouseTransferShipmentReceipt $shipmentReceipt;

    /**
     * WarehouseTransferReceived constructor.
     */
    public function __construct(WarehouseTransferShipmentReceipt $shipmentReceipt)
    {
        $this->shipmentReceipt = $shipmentReceipt;
    }
}
