<?php

namespace App\Events;

use App\Models\WarehouseTransfer;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class WarehouseTransferInitiated implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public WarehouseTransfer $warehouseTransfer;

    /**
     * Create a new event instance.
     */
    public function __construct(WarehouseTransfer $warehouseTransfer)
    {
        $this->warehouseTransfer = $warehouseTransfer;
    }
}
