<?php

namespace App\Events;

use App\Models\Product;
use App\Models\SalesChannel;
use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;

class SalesChannelListingLinked implements ShouldQueue
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    public Product $product;

    public SalesChannel $salesChannel;

    /**
     * Create a new event instance.
     */
    public function __construct(Product $product, SalesChannel $salesChannel)
    {
        $this->product = $product;
        $this->salesChannel = $salesChannel;
    }
}
