<?php

namespace App;

/**
 * Here are some helper methods which a developer might use on occasion.
 * The methods here should not be used as part of the application code.
 * Calls to these methods should not be committed to the git branch
 */
class DevHelpers
{
    /**
     * better version of `var_export()` which uses modern [] array format
     */
    public static function varExport($expression): void
    {
        if (! is_array($expression)) {
            var_export($expression);
        }
        $export = var_export($expression, true);
        $export = preg_replace('/^([ ]*)(.*)/m', '$1$1$2', $export);
        $array = preg_split("/\r\n|\n|\r/", $export);
        $array = preg_replace(["/\s*array\s\($/", "/\)(,)?$/", "/\s=>\s$/"], [null, ']$1', ' => ['], $array);
        $export = implode(PHP_EOL, array_filter(['['] + $array));
        echo $export.PHP_EOL;
    }
}
