<?php

namespace App\DataTable;

use Illuminate\Pagination\LengthAwarePaginator;

class DataTablePaginator extends LengthAwarePaginator
{
    /**
     * Get the number of the first item in the slice.
     */
    public function firstItem(): ?int
    {
        if ($this->currentPage > $this->lastPage) {
            return null;
        }

        return ($this->currentPage - 1) * $this->perPage + 1;
    }

    /**
     * Get the number of the last item in the slice.
     */
    public function lastItem(): ?int
    {
        if ($this->currentPage > $this->lastPage) {
            return null;
        }

        return $this->currentPage == $this->lastPage ? $this->total : ($this->firstItem() ?? 0) + $this->perPage - 1;
    }
}
