<?php

namespace App\DataTable;

/*
 * TODO: Convert these to static functions once we remove the conflicts in Filterable and Sortable
 */

use Spatie\LaravelData\DataCollection;

interface DataTableModelInterface
{
    public static function isDeletable(): bool;

    public static function frozenColumns(): array;

    public static function defaultSort(): array;

    public static function defaultDensity(): string;

    // TODO: Make this return void since it will just set the protected variable on the model
    public function availableColumns(): array;

    public function visibleColumns(): array;

    /*
     * Labels not following the pattern of capitalizing first letter of each word of field name
     */
    public static function specialLabels(): array;

    // TODO: Make this return void since it will just set the protected variable on the model
    public function filterableColumns(): array;

    public function scopeColumns(): array;

    /*
     * Searchable within general data table search
     */
    public function generalFilterableColumns(): array;

    public function sortableColumns(): array;

    public function columnGroups(): DataCollection;
}