<?php

namespace App\Data;

use App\Models\WarehouseTransfer;
use Carbon\Carbon;
use DateTimeInterface;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\BeforeOrEqual;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class WarehouseTransferReceiptData extends Data
{
    public function __construct(
        #[Exists('warehouse_transfer_shipments','id')]
        public int|Optional $shipment_id,
        public string|Optional $receipt_date,
        #[DataCollectionOf(WarehouseTransferReceiptProductData::class)]
        public DataCollection $products,
        #[DataCollectionOf(WarehouseTransferReceiptBlemishedData::class)]
        public DataCollection|Optional $blemished,
    )
    {
        if ($this->receipt_date instanceof Optional) {
            $this->receipt_date = Carbon::now()->toDateTimeString();
        }
    }
}
