<?php

namespace App\Data;

use Illuminate\Support\Str;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;

class UserData extends Data
{
    public function __construct(
        #[Rule('required|unique:users,email|max:255|email')]
        public string $email,
        #[Rule('required|string|max:255')]
        public string $name,
        public bool $is_admin = false,
        public bool $is_power_user = false,
        public ?string $password = null,
    ) {
        $this->password = $password ?? Str::random(8);
    }
}
