<?php

namespace App\Data;

use App\Models\InventoryAdjustment;
use App\Models\NominalCode;
use App\Models\SalesCreditLine;
use App\Models\SalesOrderLine;
use App\Models\TaxRate;
use App\Rules\StandardProductRule;
use App\SDKs\ShipStation\Model\XML\Option;
use Spatie\LaravelData\Attributes\Validation\BooleanType;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Required;
use Spatie\LaravelData\Attributes\Validation\RequiredWithout;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;
use Spatie\LaravelData\Support\Validation\ValidationContext;


class UpdateSalesCreditLineData extends Data
{
    public function __construct(
        #[RequiredWithout('id'), Rule(['numeric','min:1'])]
        public int|Optional $quantity,

        #[Exists(SalesOrderLine::class, 'id')]
        public int|Optional $sales_order_line_id,

        #[Exists(NominalCode::class, 'id')]
        public int|Optional $nominal_code_id,

        #[RequiredWithout('id'), Rule('max:255')]
        public string|Optional $description,

        #[RequiredWithout('id'), Rule('numeric')]
        public float|Optional $amount,

        public int|Optional $discount,

        #[Exists(TaxRate::class, 'id')]
        public int|null $tax_rate_id,

        public bool $is_product = false,

        #[Exists(SalesCreditLine::class, 'id'),Rule("nullable")]
        public int|Optional|null $id = null,
    ) {
    }
}