<?php

namespace App\Data;

use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\Min;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class StockTakeItemBulkData extends Data
{
    public function __construct(
        public int $stock_take_id,
        #[Exists('products', 'id')]
        public int $product_id,
        #[Min(1)]
        public float|Optional $qty_counted, // Can set up stock take before doing count
        #[Min(0.01)]
        public ?float $unit_cost, // Can set up stock take before doing count
    )
    {
    }
}
