<?php

namespace App\Data;

use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class ShippingProviderIntegrationSettingsData extends Data
{
    public function __construct(
        public string $connection_name,
        public Warehouse|Model|array|Optional $linked_warehouse,
        public bool $automate_fulfillment = false,
    ) {}


    public static function fromRequest(Request $request): ShippingProviderIntegrationSettingsData{
        return new self(
            connection_name: $request->input('integration_settings.connection_name'),
            linked_warehouse: Warehouse::query()->findOrFail($request->input('integration_settings.linked_warehouse_id')),
            automate_fulfillment: $request->input('integration_settings.automate_fulfillment'),
        );
    }
}
