<?php

namespace App\Data;

use DateTime;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\WithCast;
use Spatie\LaravelData\Casts\DateTimeInterfaceCast;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class SalesOrderFulfillmentData extends Data
{
    public function __construct(
        public int $sales_order_id,
        public int $fulfillment_sequence,
        public int $warehouse_id,
        public string $status,
        public string $fulfillment_type,
        #[WithCast(DateTimeInterfaceCast::class)]
        public DateTime $fulfilled_at,
        public int $user_id,
        #[DataCollectionOf(SalesOrderFulfillmentLineData::class)]
        public array|Optional $fulfillment_lines,
        public int|Optional|null $fulfilled_shipping_method_id,
        public string|Optional|null $tracking_number,
    ) {}
}
