<?php

namespace App\Data;

use App\Abstractions\Integrations\SalesChannels\AbstractSalesChannelProduct;
use App\Models\Product;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class SalesChannelProductToSkuProductMappingData extends Data
{
    public function __construct(
        // TODO: Add exists validation to make sure the sku exists in the model table once I figure out abstraction
        public string $sales_channel_listing_id,
        public AbstractSalesChannelProduct|Optional $salesChannelProduct,
        public ?string $mapped_sku,
        public Product|Optional|null $product,
        public int|Optional|null $product_listing_id,
    )
    {
    }
}
