<?php

namespace App\Data;

use App\Abstractions\HasNotesInterface;
use Spatie\LaravelData\Attributes\Validation\Required;
use Spatie\LaravelData\Attributes\Validation\RequiredIf;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;
use Illuminate\Validation\Validator;

class NoteData extends Data
{
    public function __construct(
        public int|Optional $link_id,
        public string|Optional $link_type,
        public null|int|Optional $user_id,
        public string $note,
    ) {
    }

    public static function withValidator(Validator $validator): void
    {
        $attributes = $validator->getData();
        if (!class_exists($attributes['link_type'])) {
            $validator->errors()->add('link_type', 'The link_type must be a valid class.');
        } else {
            $model = app($attributes['link_type']);
            if (!$model instanceof HasNotesInterface) {
                $validator->errors()->add('link_type', 'The link_type must implement HasNotesInterface.');
            }
        }
    }
}
