<?php

namespace App\Data;

use Carbon\Carbon;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class IntegrationInstanceInventoryData extends Data
{
    public function __construct(
        public InventoryModificationRulesData|Optional $inventoryModificationRules,
        #[DataCollectionOf(InventoryLocationData::class)]
        public DataCollection|Optional $locations,
        public int|Optional $fulfillmentLatency,
        public string|Optional|null $masterOfStock,
        public array|Optional $selectedWarehouses,
        public Carbon|Optional|null $lastSyncedAt,
    ) {}
}
