<?php

namespace App\Data;

use App\Models\Warehouse;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Attributes\Validation\GreaterThan;
use Spatie\LaravelData\Attributes\Validation\Min;
use Spatie\LaravelData\Data;

class InitialInventoryData extends Data
{
    public function __construct(
        #[Exists(Warehouse::class,'id')]
        public int $warehouse_id,
        #[Min(0)]
        public int $quantity,
        #[Min(0)]
        public float $unit_cost,
    )
    {
    }
}
