<?php

namespace App\Data;

use App\Models\SalesChannel;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class CustomerData extends Data
{
    public function __construct(
        public int|Optional $id,
        public ?string $name,
        public ?string $email,
        public ?string $zip,
        public ?string $address1,
        public ?string $company,
        public ?string $phone,
        public AddressData|Optional $default_shipping_address,
        public int|null|Optional $default_shipping_address_id,
        public AddressData|Optional $default_billing_address,
        public int|null|Optional $default_billing_address_id,
        public int $sales_channel_origin_id = SalesChannel::LOCAL_CHANNEL_ID,
    ) {
    }

    public function encryptPii(): self
    {
        $this->name = encryptValue($this->name);
        $this->email = encryptValue($this->email);
        $this->address1 = encryptValue($this->address1);
        $this->phone = encryptValue($this->phone);

        if (!$this->default_shipping_address instanceof Optional) {
            $this->default_shipping_address?->encryptPii();
        }

        if (!$this->default_billing_address instanceof Optional) {
            $this->default_billing_address?->encryptPii();
        }

        return $this;
    }
}
