<?php

namespace App\Data;

use App\Rules\StandardWarehouseRule;
use Illuminate\Support\Facades\Validator;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class CreateStockTakeData extends Data
{
    public function __construct(
        public string|Optional $status, // Will default to 'draft' if not provided
        public string|Optional $date_count, // Will default to now() if not provided
        #[Exists('warehouses', 'id')]
        public int $warehouse_id,
        #[DataCollectionOf(StockTakeItemData::class)]
        public DataCollection|Optional $items,
        public string|null|Optional $notes,
    )
    {
        Validator::make($this->toArray(), [
            'warehouse_id' => [new StandardWarehouseRule()],
        ])->validate();
    }
}
