<?php

namespace App\Data;

use Illuminate\Http\Request;
use Spatie\LaravelData\Attributes\Validation\RequiredIf;
use Spatie\LaravelData\Attributes\Validation\RequiredUnless;
use Spatie\LaravelData\Attributes\Validation\Rule;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class CreateInventoryAdjustmentFromBlemishedProductData extends Data
{
    public function __construct(
        public string $adjustment_date,
        #[Rule('required|exists:warehouses,id')]
        public int $warehouse_id,
        public ?string $notes,
        public Optional|string $link_type,
        public Optional|int $link_id,
        public float $unit_cost = 0,
        public int $quantity = 1,
    ) {
    }

}
