<?php

namespace App\Data;

use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\Validation\Exists;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class CreateDropshipData extends Data
{
    public function __construct(
        #[Exists('sales_orders', 'id')]
        public int $sales_order_id,
        #[Exists('warehouses', 'id')]
        public int $warehouse_id,
        public string|null|Optional $supplier_notes,
        public string|null|Optional $internal_notes,
        #[Exists('shipping_methods', 'id')]
        public int|Optional $requested_shipping_method_id,
        public string|Optional $requested_shipping_method,
        #[DataCollectionOf(CreateDropshipLinesData::class)]
        public DataCollection $sales_order_lines,
    )
    {
    }
}
