<?php

namespace App\Data;

use App\Enums\AccountingTransactionLineTypeEnum;
use App\Enums\AccountingTransactionTypeEnum;
use DateTime;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Attributes\WithCast;
use Spatie\LaravelData\Casts\DateTimeInterfaceCast;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class AccountingTransactionData extends Data
{
    public function __construct(
        public string|Optional $transaction_date,
        public AccountingTransactionTypeEnum $type,
        public int $link_id,
        public string $link_type,
        public string|null|Optional $name,
        public string|null|Optional $email,
        public float|Optional $total,
        public string|Optional $reference,
        public bool|Optional|null $is_tax_included,
        public int|null|Optional $tax_rate_id,
        public float|Optional $tax_amount,
        public string|Optional|null $currency_code,
        public float|Optional|null $currency_rate,
        public bool|Optional $is_batchable,
        public int|null|Optional $accounting_integration_id,
        public string|null|Optional $accounting_integration_type,
        #[WithCast(DateTimeInterfaceCast::class)]
        public DateTime|null|Optional $submission_started_at,
        public int|null|Optional $parent_id,
        #[DataCollectionOf(AccountingTransactionLineData::class)]
        public DataCollection|Optional $accounting_transaction_lines,
        public bool|Optional $is_sync_enabled = true,
    )
    {
        if ($this->total instanceof Optional) {
            $this->total = $this->accounting_transaction_lines
                ->toCollection()
                // Don't include credits to avoid double counting
                ->reject(function ($item) {
                    return $item->type === AccountingTransactionLineTypeEnum::CREDIT;
                })->sum(fn($item) => $item->quantity * $item->amount);

        }
    }
}
