<?php

namespace App\DTO;

use App\Collections\WarehouseTransferLineCollection;
use Carbon\Carbon;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class WarehouseTransferDto extends Data
{
    public function __construct(
        public string $warehouse_transfer_number,
        public string $transfer_date,
        public int $from_warehouse_id,
        public int $to_warehouse_id,
        public int|null|Optional $shipping_method_id,
        public string|Optional $transfer_status,
        #[DataCollectionOf(WarehouseTransferLineDto::class)]
        public DataCollection|Optional $warehouseTransferLines,
    ) {
    }
}
