<?php

namespace App\DTO;

use App\Helpers;
use App\Models\Setting;
use Spatie\LaravelData\Data;

class SupplierDTO extends Data
{
    public function __construct(
        public string $name,
        public ?string $timezone,
    )
    {
        if (!$this->timezone)
        {
            $this->timezone = Helpers::setting(Setting::KEY_DEFAULT_TIMEZONE, null, true);
        }
    }


}
