<?php

namespace App\DTO;

use Carbon\Carbon;
use Spatie\LaravelData\Data;

class SalesOrderFulfillmentDto extends Data
{
    public function __construct(
        public ?int $id,
        public string $fulfillment_type,
        public Carbon $fulfilled_at,
        public ?int $shipping_method_id,
        public string $fulfilled_shipping_method,
        public ?string $requested_shipping_method,
        public string $tracking_number,
        public ?int $warehouse_id,
        public array $fulfillment_lines,
        public bool $submit_to_shipping_provider = true,
        public bool $submit_to_sales_channel = true,
    ) {
    }
}
