<?php

namespace App\DTO;

use App\Collections\SalesCreditLineCollection;
use Carbon\Carbon;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class SalesCreditDto extends Data
{
    public function __construct(
        public string|Optional $sales_credit_number,
        public Carbon|Optional $credit_date,
        public int|null|Optional $sales_order_id,
        public int|null|Optional $store_id,
        public int|null|Optional $customer_id,
        public int|null|Optional $from_address_id,
        public int|null|Optional $to_warehouse_id,
        public string|null|Optional $sales_credit_note,
        public SalesCreditLineCollection $sales_credit_lines,
    ) {
    }
}
