<?php

namespace App\DTO;

use Spatie\LaravelData\Data;
use Spatie\LaravelData\Optional;

class ReportingDailyFinancialDto extends Data
{
    public function __construct(
        public int|Optional $reportable_id,
        public string|Optional $reportable_type,
        public string|Optional $date,
        public int $quantity = 0,
        public int $num_orders = 0,
        public float $revenue = 0,
        public float $revenue_allocated = 0,
        public float $revenue_credits = 0,
        public float $cost = 0,
        public float $cost_allocated = 0,
        public float $cost_invoices = 0,
        public float $cost_returned = 0,
    ) {
    }
}
