<?php

namespace App\DTO;

use App\Repositories\CurrencyRepository;
use Carbon\Carbon;
use Spatie\LaravelData\Attributes\DataCollectionOf;
use Spatie\LaravelData\Data;
use Spatie\LaravelData\DataCollection;
use Spatie\LaravelData\Optional;

class PurchaseOrderDto extends Data
{
    public function __construct(
        public string|Optional $purchase_order_number,
        public int|Optional $sequence,
        public string $purchase_order_date,
        public int|Optional $store_id,
        public int $supplier_id,
        public int|Optional $currency_id,
        public string|Optional $currency_code,
        public float|Optional $currency_rate,
        public int|Optional $currency_id_tenant_snapshot,
        public int $destination_warehouse_id,
        public string|Optional $order_status,
        #[DataCollectionOf(PurchaseOrderLineDto::class)]
        public DataCollection|Optional $purchaseOrderLines,
        public string|Optional $submission_format,
    ) {
        if ($this->currency_id_tenant_snapshot instanceof Optional) {
            $this->currency_id_tenant_snapshot = app(CurrencyRepository::class)->getDefault(true)->id;
        }
    }
}
