<?php

namespace App\DTO;

use App\Abstractions\Integrations\IntegrationInstanceInterface;
use App\Collections\ProductListingCollection;
use Spatie\LaravelData\Data;

class ProductListingBulkDto extends Data
{
    public function __construct(
        public ProductListingCollection $data,
        public IntegrationInstanceInterface $integrationInstance,
        public bool $insert,
        public bool $update,
        public array $metadata,
        public bool $hasProductId = false
    ) {
    }

    public function count(): int
    {
        return $this->data->count();
    }
}
